package com.almworks.jira.structure.api.item;

import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;

/**
 * This interface lists main item types that come bundled with Structure plugin.
 */
@PublicApi
public interface CoreItemTypes {
  String ISSUE = "com.almworks.jira.structure:type-issue";
  String PROJECT = "com.almworks.jira.structure:type-project";
  String VERSION = "com.almworks.jira.structure:type-version";
  String VERSION_NAME = "com.almworks.jira.structure:type-version-name";
  String COMPONENT = "com.almworks.jira.structure:type-project-component";
  String ISSUETYPE = "com.almworks.jira.structure:type-issuetype";
  String STATUS = "com.almworks.jira.structure:type-status";
  String RESOLUTION = "com.almworks.jira.structure:type-resolution";
  String PRIORITY = "com.almworks.jira.structure:type-priority";
  String LABEL = "com.almworks.jira.structure:type-label";
  String USER = "com.almworks.jira.structure:type-user";
  String GROUP = "com.almworks.jira.structure:type-group";
  String DATE = "com.almworks.jira.structure:type-date";
  String CF_OPTION = "com.almworks.jira.structure:type-cf-option";
  String FOLDER = "com.almworks.jira.structure:type-folder";
  String GENERATOR = "com.almworks.jira.structure:type-generator";
  String EFFECTOR = "com.almworks.jira.structure:type-effector";
  String LOOP_MARKER = "com.almworks.jira.structure:type-loop-marker";
  String STRUCTURE = "com.almworks.jira.structure:type-structure";
  String STRUCTURE_VERSION = "com.almworks.jira.structure:type-structure-version";
  String SPRINT = "com.almworks.jira.structure:type-sprint";
  String TEMPO_ACCOUNT = "com.almworks.jira.structure:type-tempo-account";
  String REQUEST_TYPE = "com.almworks.jira.structure:type-sd-request-type";
  String MISSING = "com.almworks.jira.structure:type-missing";
  String MEMO = "com.almworks.jira.structure:type-memo";
  String ARTIFICIAL = "com.almworks.jira.structure:type-artificial";
  String PROJECT_CATEGORY = "com.almworks.jira.structure:type-project-category";
  String ATTACHMENT = "com.almworks.jira.structure:type-attachment";
  String COMMENT = "com.almworks.jira.structure:type-comment";
  String WORKLOG = "com.almworks.jira.structure:type-worklog";
  String CHANGE_HISTORY_GROUP = "com.almworks.jira.structure:type-change-history-group";
  String CHANGE_HISTORY_ITEM = "com.almworks.jira.structure:type-change-history-item";
  String MEMO_CHANGE_HISTORY_GROUP = "com.almworks.jira.structure:type-memo-change-history-group";
  String ISSUE_LINK = "com.almworks.jira.structure:type-issue-link";
  String ISSUE_LINK_TYPE = "com.almworks.jira.structure:type-issue-link-type";
  String STANDARD_TYPE_PREFIX = "com.almworks.jira.structure:type-";

  @NotNull
  static String simplifyType(@NotNull String type) {
    return type.startsWith(STANDARD_TYPE_PREFIX) ? type.substring(STANDARD_TYPE_PREFIX.length()) : type;
  }
}
