package com.almworks.jira.structure.api.attribute;

import com.almworks.jira.structure.api.item.ItemIdentity;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.Nullable;

/**
 * An object that implements {@code ItemValues} interface is supplied as a result of attributes calculation by
 * {@link StructureAttributeService#getItemValues}. The interface allows retrieval of values by item and attribute specification.
 *
 * @see RowValues
 * @see StructureAttributeService
 * @see AttributeSpec
 */
@PublicApi
public interface ItemValues extends LoadedValues<ItemIdentity> {
  ItemValues EMPTY = new ItemValues() {
    @Nullable
    @Override
    public <T> LoadedValue<T> getLoadedValue(@Nullable ItemIdentity key, @Nullable AttributeSpec<T> attribute) {
      return null;
    }
  };
}
