package com.almworks.jira.structure.api.folder;

import com.almworks.jira.structure.api.error.StructureException;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface FolderManager {
  long createFolder(@NotNull Folder folder) throws StructureException;

  @Nullable
  Folder getFolder(long id);

  void updateFolder(long id, @NotNull Folder folder) throws StructureException;

  void deleteFolder(long id) throws StructureException;
}
