package com.almworks.jira.structure.api.process;

import com.almworks.jira.structure.api.util.I18nText;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ProcessButtonParameters {
  private I18nText myCaption;
  private String myUrl;

  public ProcessButtonParameters(I18nText caption, String url) {
    myCaption = caption;
    myUrl = url;
  }

  public ProcessButtonParameters() {}

  public I18nText getCaption() {
    return myCaption;
  }

  public void setCaption(I18nText caption) {
    myCaption = caption;
  }

  public String getUrl() {
    return myUrl;
  }

  public void setUrl(String url) {
    myUrl = url;
  }


  @Override
  public boolean equals(Object obj) {
    if (obj == null) { return false; }
    if (obj == this) { return true; }
    if (obj.getClass() != getClass()) {
      return false;
    }
    ProcessButtonParameters rhs = (ProcessButtonParameters) obj;
    return new EqualsBuilder()
      .append(this.myCaption, rhs.myCaption)
      .append(this.myUrl, rhs.myUrl)
      .isEquals();
  }

  @Override
  public int hashCode() {
    return new HashCodeBuilder()
      .append(myCaption)
      .append(myUrl)
      .toHashCode();
  }
}
