package com.almworks.jira.structure.api.property;

import com.atlassian.annotations.Internal;
import org.jetbrains.annotations.*;

@Internal
public interface PropertyService {
  /**
   * @param key shouldn't be longer than 190 characters - see AOUtil.MAX_STRING_FIELD_LENGTH.
   */
  @Contract("_, null -> _; _, !null -> !null")
  String getString(@NotNull String key, @Nullable String defaultValue);

  boolean getBoolean(@NotNull String key, boolean defaultValue);

  long getLong(@NotNull String key, long defaultValue);

  void set(@NotNull String key, @Nullable String value);

  void set(@NotNull String key, boolean value);

  void set(@NotNull String key, long value);

  void remove(@NotNull String key);

  /**
   * Invalidates the value cache, so the next get() will reload the value from the database. The invalidation
   * will also clear the cache on other nodes.
   *
   * NB: set() operations automatically send invalidation. This method can be used to ensure that the value read
   * is not stale (under a global lock).
   */
  void invalidate(@NotNull String key);
}
