package com.almworks.jira.structure.api.i18n;

import com.almworks.jira.structure.api.auth.StructureAuth;
import com.almworks.jira.structure.api.util.CallableE;
import com.almworks.jira.structure.api.util.JiraComponents;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.Locale;

import static com.almworks.jira.structure.api.util.StructureUtil.getJiraDefaultLocale;

@Internal
public class JiraI18n implements I18n {
  private final I18nHelper myHelper;

  public JiraI18n(I18nHelper helper) {
    myHelper = helper;
  }

  @Override
  public String getText(String key, Object... parameters) {
    return myHelper.getText(key, parameters);
  }

  @Override
  public Locale getLocale() {
    return myHelper.getLocale();
  }

  public static I18n forCurrentUser() {
    return create(null, StructureAuth.getUser());
  }

  @NotNull
  public static I18n create(@Nullable final Locale locale, @Nullable final ApplicationUser user) {
    final I18nHelper.BeanFactory factory = ComponentAccessor.getI18nHelperFactory(); // TCCL ok
    if (factory == null) return new DummyI18n();
    return JiraComponents.withThreadContextClassLoaderOf(factory, new CallableE<JiraI18n, RuntimeException>() {
      @Override
      public JiraI18n call() {
        I18nHelper helper = locale != null || user == null
          ? factory.getInstance(locale != null ? locale : getJiraDefaultLocale())
          : factory.getInstance(user);
        return new JiraI18n(helper);
      }
    });
  }

  private static class DummyI18n implements I18n {
    @Override
    public String getText(String key, Object... parameters) {
      return key + ' ' + Arrays.toString(parameters);
    }

    @Override
    public Locale getLocale() {
      return Locale.ENGLISH;
    }
  }
}
