package com.almworks.jira.structure.api.attribute.loader;

import com.almworks.jira.structure.api.row.StructureRow;
import com.atlassian.annotations.PublicApi;
import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * <p>The context interface for aggregate attribute loaders.</p>
 *
 * @see AggregateAttributeLoader
 */
@PublicApi
public interface AggregateAttributeContext extends RowAttributeContext {
  /**
   * Returns a list of children rows of the currently loaded row.
   *
   * @return children rows
   */
  @NotNull
  List<StructureRow> getChildren();
}
