package com.almworks.jira.structure.api.effect;

import com.almworks.jira.structure.api.error.StructureException;
import com.atlassian.annotations.PublicSpi;
import org.jetbrains.annotations.NotNull;

/**
 * A piece of runnable code generated by an {@link EffectProvider effect
 * provider} from an {@link StoredEffect effect description}.
 */
@PublicSpi
public interface Effect {
  /**
   * Performs the actual changes in the state of the world. Returns an {@link
   * StoredEffect effect desription} that undoes those changes.
   *
   * @throws StructureException if it is impossible to apply the effect despite
   *         all prior checks made by the {@link EffectProvider}. Usually means
   *         that the state of the world has changed unexpectedly since those
   *         checks were made.
   */
  @NotNull
  StoredEffect apply() throws StructureException;
}
