package com.almworks.jira.structure.api.util;

import com.almworks.integers.*;
import com.atlassian.jira.util.lang.Pair;
import org.jetbrains.annotations.NotNull;

import java.util.ConcurrentModificationException;
import java.util.function.LongPredicate;

public class LongFilteringIterator extends LongFindingIterator {
  private final LongIterator mySource;
  private final LongPredicate myFilter;

  public LongFilteringIterator(LongIterator source, La<Long, ?> filter) {
    mySource = source;
    myFilter = filter::accepts;
  }

  public LongFilteringIterator(@NotNull LongIterator source, @NotNull LongPredicate filter) {
    mySource = source;
    myFilter = filter;
  }

  @Override
  protected boolean findNext() throws ConcurrentModificationException {
    while (mySource.hasNext()) {
      long v = mySource.nextValue();
      if (myFilter.test(v)) {
        myNext = v;
        return true;
      }
    }
    return false;
  }

  public static Pair<LongIterator, LongIterator> split(LongIterator iterator, La<Long, ?> filter) {
    // todo replace LongIterator with LongIterable or optimize correctly
    LongArray array = new LongArray(iterator);
    return Pair.<LongIterator, LongIterator>of(
      new LongFilteringIterator(array.iterator(), filter),
      new LongFilteringIterator(array.iterator(), filter.not())
    );
  }
  
}
