/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import com.almworks.jira.structure.api.forest.raw.Forest;
import com.almworks.jira.structure.api.util.RowTree;
import java.util.HashMap;
import java.util.Map;

public class IndexedRowTree
extends RowTree {
    private final Map<Long, RowTree.Node> myNodeMap;

    public IndexedRowTree(int size) {
        this.myNodeMap = new HashMap<Long, RowTree.Node>(size);
    }

    public IndexedRowTree() {
        this(16);
    }

    public static IndexedRowTree create(Forest forest) {
        IndexedRowTree r = new IndexedRowTree(forest.size());
        r.appendForest(forest);
        return r;
    }

    @Override
    protected RowTree.Node createNode(long rowId, int flags) {
        RowTree.Node node = super.createNode(rowId, flags);
        RowTree.Node expunged = this.myNodeMap.put(rowId, node);
        assert (expunged == null) : "forest invariant broken: multiple nodes with id " + rowId;
        return node;
    }

    @Override
    protected void forgetNode(RowTree.Node node) {
        super.forgetNode(node);
        this.myNodeMap.remove(node.getRowId());
        for (RowTree.Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            this.forgetNode(n);
        }
    }

    public RowTree.Node getNodeWithRowId(long rowId) {
        return rowId == 0L ? this.getSuperRoot() : this.myNodeMap.get(rowId);
    }

    public boolean hasRow(long value) {
        return this.myNodeMap.containsKey(value);
    }
}

