/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.jira.structure.api.util;

import com.almworks.jira.structure.api.lifecycle.CachingComponent;
import com.almworks.jira.structure.api.util.CallableE;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.plugin.ComponentClassManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.plugin.PluginAccessor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JiraComponents
implements DisposableBean,
InitializingBean,
CachingComponent {
    private static final Map<Class<?>, ? super Object> proxyCache = new ConcurrentHashMap();

    @Nullable
    public static <T> T getOSGiComponentInstanceOfType(@NotNull Class<T> intfClass) {
        assert (intfClass.isInterface()) : intfClass;
        Object service = ComponentAccessor.getOSGiComponentInstanceOfType(intfClass);
        return (T)JiraComponents.createTCCLSwitchingProxy(intfClass, service);
    }

    @Nullable
    public static <T> T getComponentOfType(@NotNull Class<T> intfClass) {
        assert (intfClass.isInterface()) : intfClass;
        Object service = ComponentAccessor.getComponentOfType(intfClass);
        return (T)JiraComponents.getTCCLSwitchingProxy(intfClass, service);
    }

    @Nullable
    public static <T> T getComponent(@NotNull Class<T> intfClass) {
        assert (intfClass.isInterface()) : intfClass;
        Object service = ComponentAccessor.getComponent(intfClass);
        return (T)JiraComponents.getTCCLSwitchingProxy(intfClass, service);
    }

    public static JiraAuthenticationContext getJiraAuthenticationContext() {
        return JiraComponents.getTCCLSwitchingProxy(JiraAuthenticationContext.class, ComponentAccessor.getJiraAuthenticationContext());
    }

    public static ProjectManager getProjectManager() {
        return JiraComponents.getTCCLSwitchingProxy(ProjectManager.class, ComponentAccessor.getProjectManager());
    }

    public static ProjectComponentManager getProjectComponentManager() {
        return JiraComponents.getTCCLSwitchingProxy(ProjectComponentManager.class, ComponentAccessor.getProjectComponentManager());
    }

    public static ConstantsManager getConstantsManager() {
        return JiraComponents.getTCCLSwitchingProxy(ConstantsManager.class, ComponentAccessor.getConstantsManager());
    }

    public static VersionManager getVersionManager() {
        return JiraComponents.getTCCLSwitchingProxy(VersionManager.class, ComponentAccessor.getVersionManager());
    }

    public static OptionsManager getOptionsManager() {
        return JiraComponents.getTCCLSwitchingProxy(OptionsManager.class, ComponentAccessor.getOptionsManager());
    }

    public static UserManager getUserManager() {
        return JiraComponents.getTCCLSwitchingProxy(UserManager.class, ComponentAccessor.getUserManager());
    }

    public static GroupManager getGroupManager() {
        return JiraComponents.getTCCLSwitchingProxy(GroupManager.class, ComponentAccessor.getGroupManager());
    }

    public static UserUtil getUserUtil() {
        return JiraComponents.getTCCLSwitchingProxy(UserUtil.class, ComponentAccessor.getUserUtil());
    }

    public static PluginAccessor getPluginAccessor() {
        return JiraComponents.getTCCLSwitchingProxy(PluginAccessor.class, ComponentAccessor.getPluginAccessor());
    }

    public static PermissionManager getPermissionManager() {
        return JiraComponents.getTCCLSwitchingProxy(PermissionManager.class, ComponentAccessor.getPermissionManager());
    }

    public static ApplicationProperties getApplicationProperties() {
        return JiraComponents.getTCCLSwitchingProxy(ApplicationProperties.class, ComponentAccessor.getApplicationProperties());
    }

    public static IssueManager getIssueManager() {
        return JiraComponents.getTCCLSwitchingProxy(IssueManager.class, ComponentAccessor.getIssueManager());
    }

    public static AvatarManager getAvatarManager() {
        return JiraComponents.getTCCLSwitchingProxy(AvatarManager.class, ComponentAccessor.getAvatarManager());
    }

    public static ComponentClassManager getComponentClassManager() {
        return JiraComponents.getTCCLSwitchingProxy(ComponentClassManager.class, ComponentAccessor.getComponentClassManager());
    }

    public static GlobalPermissionManager getGlobalPermissionManager() {
        return JiraComponents.getTCCLSwitchingProxy(GlobalPermissionManager.class, ComponentAccessor.getGlobalPermissionManager());
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    private static <T> T getTCCLSwitchingProxy(@NotNull Class<T> intfClass, @Nullable T service) {
        if (service == null) {
            return null;
        }
        Object cache = proxyCache.get(intfClass);
        if (cache != null) {
            return (T)cache;
        }
        T proxy = JiraComponents.createTCCLSwitchingProxy(intfClass, service);
        proxyCache.put(intfClass, proxy);
        return proxy;
    }

    @Contract(value="_, null -> null; _, !null -> !null")
    private static <T> T createTCCLSwitchingProxy(@NotNull Class<T> intfClass, @Nullable T service) {
        assert (intfClass.isInterface()) : intfClass;
        return (T)(service == null ? null : Proxy.newProxyInstance(service.getClass().getClassLoader(), new Class[]{intfClass}, (InvocationHandler)new TCCLSwitchingInvocationHandler(service)));
    }

    public final void afterPropertiesSet() throws Exception {
        proxyCache.clear();
    }

    public final void destroy() throws Exception {
        proxyCache.clear();
    }

    @Override
    public void clearCaches() {
        proxyCache.clear();
    }

    @Override
    public void clearUserCaches(@NotNull ApplicationUser user) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> T withThreadContextClassLoaderOf(@NotNull Object object, @NotNull CallableE<T, E> code) throws E {
        Thread thread = Thread.currentThread();
        ClassLoader ccl = thread.getContextClassLoader();
        thread.setContextClassLoader((object instanceof Class ? (Class<?>)object : object.getClass()).getClassLoader());
        try {
            T t = code.call();
            return t;
        }
        finally {
            thread.setContextClassLoader(ccl);
        }
    }

    private static final class TCCLSwitchingInvocationHandler
    implements InvocationHandler {
        private final Object myService;
        private final ClassLoader myClassLoader;

        public TCCLSwitchingInvocationHandler(Object service) {
            this.myService = service;
            this.myClassLoader = service.getClass().getClassLoader();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Thread thread = Thread.currentThread();
            ClassLoader ccl = thread.getContextClassLoader();
            thread.setContextClassLoader(this.myClassLoader);
            try {
                Object object = method.invoke(this.myService, args);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                thread.setContextClassLoader(ccl);
            }
        }
    }
}

